//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "OpenGLPanel"
#pragma resource "*.dfm"

#define V_A -1.0,-1.0,-1.0
#define V_B 1.0,-1.0,-1.0
#define V_C 1.0,1.0,-1.0
#define V_D -1.0,1.0,-1.0

#define V_E 1.0,-1.0,1.0
#define V_F -1.0,-1.0,1.0
#define V_G -1.0,1.0,1.0
#define V_H 1.0,1.0,1.0


TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//------------------------------------------------------
void TForm1::AntiAlias(void)
{
  float distance;
  float x = 1.0f;
  float y = 0.3f;
  float z = 0.2f;
  float tx,ty;
  int i;

  // SuperSampling is done using scattering method
  // 8 sample points around circle, distance is distance from
  // center of circle.
  distance = (float)DistanceBar->Position;
  distance *= 0.0004;

  // dithering state
  if(!Dither->Checked) glEnable(GL_DITHER);

  // wipe screen (and z-buffer if needed)
  glClear(GL_COLOR_BUFFER_BIT);
  //glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  // here we render 8 images to produce supersampling
  for(i=0;i<8;i++){
    glPushMatrix();

    tx = cos((i/8.0)*6.283) * distance;
    ty = sin((i/8.0)*6.283) * distance;
    glTranslated(tx, ty, -5.0);
    glRotatef(RotX, x, y, z);
    DrawCube();

    glPopMatrix();
  }

  glDisable(GL_DITHER);
}
//-------------------------------------------------------
void TForm1::MotionBlur(void)
{
  float delta;
  float x = 1.0f;
  float y = 0.3f;
  float z = 0.2f;
  int i;

  delta = (RotX_new - RotX) / 8.0;

  // dithering state
  if(!Dither->Checked) glEnable(GL_DITHER);

  // wipe screen (and z-buffer if needed)
  glClear(GL_COLOR_BUFFER_BIT);
  //glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glPushMatrix();
  glTranslated(0.0, 0.0, -5.0);
  glRotatef(RotX, x, y, z);

  // draw first cube
  DrawCube();
  // draw rest cubes with rotation for motion effect
  for(i=0;i<7;i++){
    glRotatef(delta, x, y, z);  // motion is added in here
    DrawCube();
  }

  glPopMatrix();
  glDisable(GL_DITHER);
}
//------------------------------------------------------
void TForm1::DOF(void)
{
  float distance;
  float x = 1.0f;
  float y = 0.3f;
  float z = 0.2f;
  float tx,ty,tz;
  int i;
  float zmove=0.0;

  // Depth of field is done using scattering method
  // 8 sample points around circle depending of view distance
  zmove = (float)ViewBar->Position;
  zmove -= 50.0;
  distance = zmove * 0.005;

  if(zmove>=0.0){
    tz = (zmove/30.0) - 5.0;
    distance = zmove * 0.001;
  } else {
    tz = (zmove/10.0) -5.0;
    distance = zmove * 0.003;
  }


  // dithering state
  if(!Dither->Checked) glEnable(GL_DITHER);

  // wipe screen (and z-buffer if needed)
  glClear(GL_COLOR_BUFFER_BIT);
  //glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  // here we render 8 images to produce supersampling
  for(i=0;i<8;i++){
    glPushMatrix();

    tx = cos((i/8.0)*6.283) * distance;
    ty = sin((i/8.0)*6.283) * distance;
    glTranslated(tx, ty, tz);
    glRotatef(RotX, x, y, z);
    DrawCube();

    glPopMatrix();
  }

  glDisable(GL_DITHER);
}
//------------------------------------------------------
void TForm1::DrawCube(void)
{
  float c=0.125f;

  glBegin(GL_TRIANGLES);
    glColor3f(c,c,c);
    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_A );
    glTexCoord2f(1.0f, 0.0f);
    glVertex3f( V_B );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_C);

    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_A );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_C );
    glTexCoord2f(0.0f, 1.0f);
    glVertex3f( V_D );
  glEnd();

  glBegin(GL_TRIANGLES);
    glColor3f(c,c,c);
    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_B );
    glTexCoord2f(1.0f, 0.0f);
    glVertex3f( V_E );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_H );

    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_B );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_H );
    glTexCoord2f(0.0f, 1.0f);
    glVertex3f( V_C );
  glEnd();

  glBegin(GL_TRIANGLES);
    glColor3f(c,c,c);
    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_F );
    glTexCoord2f(1.0f, 0.0f);
    glVertex3f( V_A );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_D );

    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_F );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_D );
    glTexCoord2f(0.0f, 1.0f);
    glVertex3f( V_G );
  glEnd();

  glBegin(GL_TRIANGLES);
    glColor3f(c,c,c);
    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_F );
    glTexCoord2f(1.0f, 0.0f);
    glVertex3f( V_E );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_B );

    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_F );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_B );
    glTexCoord2f(0.0f, 1.0f);
    glVertex3f( V_A );
  glEnd();

  glBegin(GL_TRIANGLES);
    glColor3f(c,c,c);
    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_D );
    glTexCoord2f(1.0f, 0.0f);
    glVertex3f( V_C );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_H );

    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_D );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_H );
    glTexCoord2f(0.0f, 1.0f);
    glVertex3f( V_G );
  glEnd();

  glBegin(GL_TRIANGLES);
    glColor3f(c,c,c);
    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_E );
    glTexCoord2f(1.0f, 0.0f);
    glVertex3f( V_F );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_G );

    glTexCoord2f(0.0f, 0.0f);
    glVertex3f( V_E );
    glTexCoord2f(1.0f, 1.0f);
    glVertex3f( V_G );
    glTexCoord2f(0.0f, 1.0f);
    glVertex3f( V_H );
  glEnd();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::OpenGLPanel1Init(TObject *Sender)
{
  BMPTexture *BMPTex;

  // my variables
  Distance = DistanceBar->Position;
  Speed = SpeedBar->Position;
  Pause->Checked = false;
  Radio1->Checked = true;

 	glViewport(0,0,(GLsizei)OpenGLPanel1->Width,(GLsizei)OpenGLPanel1->Height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
  if ( OpenGLPanel1->Height==0)
   	gluPerspective(45, (GLdouble)OpenGLPanel1->Width, 1.0, 2000.0);
  else
    gluPerspective(45, (GLdouble)OpenGLPanel1->Width/
                           (GLdouble)OpenGLPanel1->Height,1.0, 2000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	//glEnable(GL_DEPTH_TEST);
	glDisable(GL_DEPTH_TEST);
  glClearColor(0.0,0.0,0.0,1.0);


  // gl init
  glShadeModel(GL_FLAT);
  glEnable(GL_CULL_FACE);
  glCullFace(GL_BACK);
  glFrontFace(GL_CW);
  glBlendFunc(GL_ONE,GL_ONE);
  glEnable(GL_BLEND);
  glDisable(GL_DITHER);
  //glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
  glEnable(GL_TEXTURE_2D);
  //glEnable(GL_NORMALIZE);
  //glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

  // texture loading  NOTE! false = no alpha, true = alpha
  BMPTex = OpenGLPanel1->LoadBMPTexture("kuva.bmp",false);
  if (BMPTex)
    {
      //BMPTex->SetAlpha(128);
      //BMPTex->SetAlpha(255);
      glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
      glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
      glTexImage2D(GL_TEXTURE_2D, 0, BMPTex->GetComponents(),
                   BMPTex->GetWidth(), BMPTex->GetHeight(),0,
                   BMPTex->GetFormat(),BMPTex->GetType(),
                   BMPTex->GetPixels());
    }


}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenGLPanel1Paint(TObject *Sender)
{
  if(Radio1->Checked) {
    // go to antialias part
    AntiAlias();

  } else if(Radio2->Checked) {
    // go to motionblur part
    MotionBlur();

  }else if(Radio3->Checked) {
    // go to depth of field part
    DOF();

  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
  static int aika=0;

  if (aika!=0) {
    //dx = (kulunutaika/1000)*30.0;  not working
    dx = (float)SpeedBar->Position;

    // checking if user put program to pause mode, if paused -> no movement
    if(!Pause->Checked){
      RotX += dx;
      RotX_new = RotX + dx;
      if(RotX>360.0) { RotX -= 360.0; RotX_new -= 360.0; }
    }
    //if(RotX_new>360.0) RotX_new -= 360.0;
  } else {
    RotX = 0;
    RotY = 0;
    aika=1;
  }

  // disable timer just to be sure
  Timer1->Enabled = false;
  OpenGLPanel1->Repaint(); // calls OpenGLPanel1Paint function
  Timer1->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Label3DblClick(TObject *Sender)
{
  ViewBar->Position = 50;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Label1DblClick(TObject *Sender)
{
  SpeedBar->Position = 4;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Label2DblClick(TObject *Sender)
{
  DistanceBar->Position = 14;
}
//---------------------------------------------------------------------------

